<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8"/>

<xsl:template match="/MEREPORT">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
		<head>
			<title>Sms</title>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">
					<xsl:value-of select="csspath"/>
				</xsl:attribute>
			</link>
		</head>
		<body>
			<div id="content">		
				<h1>Sms</h1>
				<xsl:call-template name="sms"/>
			</div>
		</body>
	</html>
</xsl:template>

<xsl:template name="sms">
	<table>
		<tr>
			<th>id</th>
			<th>threadId</th>
			<th>address</th>
			<th>person</th>
			<th>date</th>
			<th>protocol</th>
			<th>read</th>
			<th>status</th>
			<th>type</th>
			<th>serviceCenter</th>
			<th>subject</th>
			<th>body</th>
		</tr>
		
		<xsl:for-each select="sms">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@threadId"/></td>
				<td><xsl:value-of select="@address"/></td>
				<td><xsl:value-of select="@person"/></td>
				<td><xsl:value-of select="@date"/></td>
				<td><xsl:value-of select="@protocol"/></td>
				<td><xsl:value-of select="@read"/></td>
				<td><xsl:value-of select="@status"/></td>
				<td><xsl:value-of select="@type"/></td>
				<td><xsl:value-of select="@serviceCenter"/></td>
				<td><xsl:value-of select="subject"/></td>
				<td><xsl:value-of select="body"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

</xsl:stylesheet>

